<?php
/**
 * Module Name: MyArcadeContest Integration
 */

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

if ( function_exists( 'myarcadecontest_init' ) ) :

 //*************** Actions ***************\\
 add_action('myarcadecontest_award_user', 'wpachievements_get_award', 10, 1);
 add_action('cp_log', 'wpachievements_contest_events', 10, 4);
 //*************** Detect user getting prize ***************\\
function wpachievements_get_award($args){
  extract($args);
  
  if ( isset( $user_id ) ) {
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'myarcadecontest_add',
      'user_id'     => $user_id,
      'post_id'     => '',
      'points'      => 0,
    ) );    
  }
}
 //*************** Detect user events ***************\\
 function wpachievements_contest_events($type, $uid, $points, $data){
   if( $type=='myarcadecontest_subcontest' ){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'myarcadecontest_subcontest',
      'user_id'     => $uid,
      'post_id'     => '',
      'points'      => 0,
    ) );         
   } elseif( $type=='myarcadecontest_subgaming' ){
    WPAchievements_Trigger::new_activity( array(
      'activity'    => 'myarcadecontest_subgaming',
      'user_id'     => $uid,
      'post_id'     => '',
      'points'      => 0,
    ) );         
   }
 }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_activity_description', 'achievement_mac_desc', 10, 4);
 function achievement_mac_desc($text='',$type='',$points='',$times=''){
  switch($type){
   case 'myarcadecontest_subgaming': { $text = sprintf( _n( 'for playing %s contest', 'for playing %s contests', $times, 'wpachievements'), $times ); } break;
   case 'myarcadecontest_add': { $text = sprintf( _n( 'for getting %s contest prize', 'for getting %s contest prizes', $times, 'wpachievements'), $times ); } break;
   case 'myarcadecontest_subcontest': { $text = sprintf( _n( 'for joining %s contest', 'for joining %s contests', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

 //*************** Descriptions ***************\\
 add_filter('wpachievements_quest_description', 'quest_mac_desc', 10, 3);
 function quest_mac_desc($text='',$type='',$times=''){
  switch($type){
   case 'myarcadecontest_subgaming': { $text = sprintf( _n( 'Play %s contest', 'Play %s contests', $times, 'wpachievements'), $times ); } break;
   case 'myarcadecontest_add': { $text = sprintf( _n( 'Get %s contest prize', 'Get %s contest prizes', $times, 'wpachievements'), $times ); } break;
   case 'myarcadecontest_subcontest': { $text = sprintf( _n( 'Join %s contest', 'Join %s contests', $times, 'wpachievements'), $times ); } break;
  }
  return $text;
 }

 //*************** Admin Events ***************\\
 add_filter('wpachievements_admin_events', 'achievement_mac_admin_events', 10);
 function achievement_mac_admin_events(){
   echo'<optgroup label="'.__('MyArcadeContests Events', 'wpachievements').'">
     <option value="myarcadecontest_add">'.__('The user wins a prize in a contest', 'wpachievements').'</option>
     <option value="myarcadecontest_subcontest">'.__('The user takes part in a contest', 'wpachievements').'</option>
     <option value="myarcadecontest_subgaming">'.__('The user plays a game as part of a contest', 'wpachievements').'</option>
   </optgroup>';

 }

 //*************** Admin Trigger Naming ***************\\
 add_filter('wpachievements_trigger_description', 'achievement_mac_admin_triggers', 1, 10);
 function achievement_mac_admin_triggers($trigger){

   switch($trigger){
     case 'myarcadecontest_add': { $trigger = __('The user wins a prize in a contest', 'wpachievements'); } break;
     case 'myarcadecontest_subcontest': { $trigger = __('The user takes part in a contest', 'wpachievements'); } break;
     case 'myarcadecontest_subgaming': { $trigger = __('The user plays a game as part of a contest', 'wpachievements'); } break;
   }

   return $trigger;
 }
endif;
?>